<?php
namespace VM\FinancialStatementsBundle\Services\Restrictions\Departments\Api;


use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;

class MethodDepartmentsRestrictions extends BasicDepartmentsRestrictions
{
    protected function checkItems()
    {
        if($this->Department->getItems()->isEmpty())
        {
            return true;
        }

        foreach($this->Department->getItems() as $Item)
        {
            $currentItems = $this->Company->getPlaces()->filter(function($Place) use($Item){return $Place->getItem()->getId() == $Item->getId();});
            if(count($currentItems)<1)
            {
                if(!isset($this->resultsData->errors[$this->Department->getType()->getSymbol()]))
                {
                    $this->resultsData->errors[$this->Department->getType()->getSymbol()] = array();
                }
                $this->resultsData->errors[$this->Department->getType()->getSymbol()][] = 'Brak: '.$Item->getName();
                $this->valid = false;
            }
            foreach($currentItems as $currentItem)
            {
//                $currentItem = new CompanyAllegroCategoryItem();
                if(!isset($this->equipment[$currentItem->getItem()->getId()]))
                {
                    $this->equipment[$currentItem->getItem()->getId()] = array(
                        'item'=>$currentItem->getItem()->getName(),
                        'count'=>0,
                    );
                }
                $this->equipment[$currentItem->getItem()->getId()]['count'] += $currentItem->getQuantity();
            }
        }
    }

    protected function checkItemsTypes()
    {
        if($this->restrictions['items'])
        {
            foreach($this->restrictions['items'] as $symbol => $requiredCount)
            {
                $count = 0;
                $items = $this->Company->getPlaces()->filter(function($Places) use($symbol){return $Places->getItem()->getType()->getSymbol() == $symbol;});
                if(count($items) > 0)
                {
                    foreach($items as $item)
                    {
                        $count += $item->getQuantity();
                    }
                }
                if($count >= $requiredCount)
                {
                    $this->equipment[] = array('item'=>$symbol,'count'=>$count);
                }
                else
                {
                    $this->valid = false;
                    if(!isset($this->resultsData->errors[$this->Department->getType()->getSymbol()]))
                    {
                        $this->resultsData->errors[$this->Department->getType()->getSymbol()] = array();
                    }
                    $this->resultsData->errors[$this->Department->getType()->getSymbol()][] = 'Brak wyposażenia typu: '.$symbol.' (wymagane: '.$requiredCount.')';
                }
            }
        }
    }

    protected function checkRequiredPersonnelEfficiency($departmentTypes)
    {
        $countEmployees = $this->getEmployees($departmentTypes);
        if(!empty($this->restrictions['personnel']))
        {
            $restrictionsPersonnel = array_reverse($this->restrictions['personnel']);
            $restrictionsEfficiency = array_reverse($this->restrictions['efficiency']);

            $this->resultsData->efficiency[$this->Department->getType()->getSymbol()] = 0;
            $equipment = 1;
            foreach($restrictionsPersonnel as $id => $restrictionPersonnel)
            {
                while($countEmployees >= $restrictionPersonnel && $equipment <= $this->countPackageEquipment && (isset($restrictionsEfficiency[$id])))
                {
                    $this->resultsData->efficiency[$this->Department->getType()->getSymbol()] += $restrictionsEfficiency[$id];
                    $countEmployees -= $restrictionPersonnel;
                    $equipment++;
                    $this->resultsData->used->surface += $this->restrictions['surface'];
                }
            }
        }

        return true;
    }

    protected function checkRequiredPersonnelEfficiencyBiR($departmentTypes)
    {
        $countEmployees = $this->getEmployees($departmentTypes);
        $package = min($countEmployees,$this->countPackageEquipment);

        if(!empty($this->restrictions['personnel']) && $package > 0)
        {
            if(isset($this->restrictions['efficiencyBiR'][$package]))
            {
                $this->resultsData->efficiencyBiR[$this->Department->getType()->getSymbol()] = $this->restrictions['efficiencyBiR'][$package];
            }
            else
            {
                $this->resultsData->efficiencyBiR[$this->Department->getType()->getSymbol()] = end($this->restrictions['efficiencyBiR']);
            }
            $this->resultsData->used->surface += $this->restrictions['surface']*$package;
        }

        return true;
    }

    protected function checkSurface($departmentTypes)
    {
        if(count($this->equipment) == 0)
        {
            return true;
        }
        $surfaceDepot = $this->getSurfaceForCompany($departmentTypes);
        $first = true;

        foreach($this->equipment as $id => $el)
        {
            if($el['count'] < $this->countPackageEquipment || $first)
            {
                $this->countPackageEquipment = $el['count'];
                $first = false;
            }
        }

        return $this->restrictions['surface']*$this->countPackageEquipment < $surfaceDepot;
    }

    private function getSurfaceForCompany($types)
    {
        $surface = 0;
        foreach($this->Company->getPlaces() as $Place)
        {
//            $Place = new CompanyAllegroCategoryItem();
            if(in_array($Place->getItem()->getType()->getSymbol(),$types))
            {
                $surface += $Place->getItem()->getSurface();
            }
        }

        return $surface;
    }

    private function getEmployees($departmentTypes)
    {
        $countEmployees = 0;
        foreach($this->Company->getCompanyEmployees() as $CompanyEmployees)
        {
//            $CompanyEmployees = new CompanyEmployee();
            if(in_array($CompanyEmployees->getDepartment()->getType()->getSymbol(),$departmentTypes)
                && (($this->restrictions['education']) ? in_array($CompanyEmployees->getEmployee()->getEducation(),$this->restrictions['education']) : true)
                && (($this->restrictions['studies']) ? in_array($CompanyEmployees->getEmployee()->getStudies(),$this->restrictions['studies']) : true)
                && (($this->restrictions['driver']) ? (strpos($CompanyEmployees->getEmployee()->getDriver(), $this->restrictions['driver']) !== false) : true)
            )
            {
                $countEmployees++;
            }
        }

        return $countEmployees;
    }

}